#ifndef _LISTBOX_CPP
#define _LISTBOX_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int InsertListBoxItemEx(HWND hWnd, const char *sInStr, int iMaxItems, int iInsertPos)
{
	// MAX Length: 32,767 Items
	int NumberOfLines = 0;

	SendMessage(hWnd, LB_INSERTSTRING, iInsertPos, (LPARAM)(LPSTR)sInStr);

	NumberOfLines = SendMessage(hWnd, LB_GETCOUNT, 0, 0);

	while(NumberOfLines > iMaxItems)
	{
		NumberOfLines = SendMessage(hWnd, LB_GETCOUNT, 0, 0);
		SendMessage(hWnd, LB_DELETESTRING, 0, FALSE);
	}

	NumberOfLines = SendMessage(hWnd, LB_GETCOUNT, 0, 0);
	SendMessage(hWnd, LB_SETCURSEL, NumberOfLines-1, 0);
	SendMessage(hWnd, LB_SETCARETINDEX, NumberOfLines-1, FALSE);

	return NumberOfLines;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int InsertListBoxItem(HWND hWnd, const char *sInStr, int iInsertPos)
{
	return InsertListBoxItemEx(hWnd, sInStr, 10240, iInsertPos);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ClearListBox(HWND hWnd)
{
	DWORD NumberOfLines = 0;

	NumberOfLines = SendMessage(hWnd, LB_GETCOUNT, 0, 0);

	SendMessage(hWnd, LB_RESETCONTENT, 0, 0);

	return NumberOfLines;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int DeleteListBoxItem(HWND hWnd, int iItemPos)
{
	DWORD NumberOfLines = 0;
	SendMessage(hWnd, LB_DELETESTRING, iItemPos,0);
	NumberOfLines = SendMessage(hWnd, LB_GETCOUNT, 0, 0);
	return NumberOfLines;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CountListBoxItems(HWND hWnd)
{
	return (int)SendMessage(hWnd, LB_GETCOUNT, 0, 0);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Use this Function only with multiple-selection list boxes.
int SelectMultipleListBoxItem(HWND hWnd, int iItemPos, BOOL Select)
{
	SendMessage(hWnd, LB_SETSEL, (WPARAM) Select, (LPARAM)iItemPos);
	return (int) SendMessage(hWnd, LB_GETCOUNT, 0, 0);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int SelectListBoxItem(HWND hWnd, int iItemPos)
{
	SendMessage(hWnd, LB_SETCURSEL, (WPARAM) iItemPos, 0);
	return (int) SendMessage(hWnd, LB_GETCOUNT, 0, 0);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CurrentListBoxItem(HWND hWnd)
{
	return (int)SendMessage(hWnd, LB_GETCURSEL, 0, 0);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void ListBoxItemTextEx(HWND hWnd, int iItemPos, char *sOutVal)
{
	SendMessage(hWnd, LB_GETTEXT, (WPARAM)iItemPos, (LPARAM)sOutVal);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char *ListBoxItemText(HWND hWnd, int iItemPos)
{
	char *Buffer = NULL;
	int Length	 = 0;
	Length = SendMessage(hWnd, LB_GETTEXTLEN, 0, 0);
	Buffer = (char *) calloc(Length+1, 1);
	SendMessage(hWnd, LB_GETTEXT, (WPARAM)iItemPos, (LPARAM)Buffer);
	return Buffer;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ListBoxItemLength(HWND hWnd, int iItemPos)
{
	return (int)SendMessage(hWnd, LB_GETTEXTLEN, iItemPos, 0);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int HorizontalListBoxExtent(HWND hWnd, int iHorzExtent)
{
	SendMessage(hWnd, (UINT)LB_SETHORIZONTALEXTENT, (WPARAM)iHorzExtent, (LPARAM)0);
	return (int) SendMessage(hWnd, LB_GETCOUNT, 0, 0);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
